/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis.en;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import morfologik.stemming.IStemmer;
import morfologik.stemming.WordData;
import org.languagetool.AnalyzedToken;
import org.languagetool.JLanguageTool;
import org.languagetool.Languages;
import org.languagetool.rules.en.AvsAnRule;
import org.languagetool.synthesis.BaseSynthesizer;

public class EnglishSynthesizer
extends BaseSynthesizer {
    private static final String RESOURCE_FILENAME = "/en/english_synth.dict";
    private static final String TAGS_FILE_NAME = "/en/english_tags.txt";
    private static final String ADD_DETERMINER = "+DT";
    private static final String ADD_IND_DETERMINER = "+INDT";
    private final AvsAnRule aVsAnRule = new AvsAnRule(JLanguageTool.getMessageBundle(Languages.getLanguageForShortCode("en")));

    public EnglishSynthesizer() {
        super(RESOURCE_FILENAME, TAGS_FILE_NAME);
    }

    @Override
    public String[] synthesize(AnalyzedToken token, String posTag) throws IOException {
        String aOrAn = this.aVsAnRule.suggestAorAn(token.getToken());
        if (ADD_DETERMINER.equals(posTag)) {
            return new String[]{aOrAn, "the " + token.getToken()};
        }
        if (ADD_IND_DETERMINER.equals(posTag)) {
            return new String[]{aOrAn};
        }
        IStemmer synthesizer = this.createStemmer();
        List<WordData> wordData = synthesizer.lookup(token.getLemma() + "|" + posTag);
        ArrayList<String> wordForms = new ArrayList<String>();
        for (WordData wd : wordData) {
            wordForms.add(wd.getStem().toString());
        }
        return wordForms.toArray(new String[wordForms.size()]);
    }

    @Override
    public String[] synthesize(AnalyzedToken token, String posTag, boolean posTagRegExp) throws IOException {
        if (posTag != null && posTagRegExp) {
            String myPosTag = posTag;
            String det = "";
            if (posTag.endsWith(ADD_IND_DETERMINER)) {
                myPosTag = myPosTag.substring(0, myPosTag.indexOf(ADD_IND_DETERMINER) - "\\".length());
                det = this.aVsAnRule.suggestAorAn(token.getLemma());
                det = det.substring(0, det.indexOf(32) + " ".length());
            } else if (posTag.endsWith(ADD_DETERMINER)) {
                myPosTag = myPosTag.substring(0, myPosTag.indexOf(ADD_DETERMINER) - "\\".length());
                det = "the ";
            }
            this.initPossibleTags();
            Pattern p = Pattern.compile(myPosTag);
            ArrayList<String> results = new ArrayList<String>();
            for (String tag : this.possibleTags) {
                Matcher m = p.matcher(tag);
                if (!m.matches()) continue;
                this.lookup(token.getLemma(), tag, results, det);
            }
            return results.toArray(new String[results.size()]);
        }
        return this.synthesize(token, posTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookup(String lemma, String posTag, List<String> results, String determiner) {
        EnglishSynthesizer englishSynthesizer = this;
        synchronized (englishSynthesizer) {
            List<WordData> wordForms = this.getStemmer().lookup(lemma + "|" + posTag);
            for (WordData wd : wordForms) {
                results.add(determiner + wd.getStem());
            }
        }
    }
}

